#include<stdio.h>
#include<string.h>

typedef struct{
	char ime[20];
	char prezime[20];
	int broj_na_bolidu;
	char naziv_tima[20];
	int broj_poena;
}vozac_formula_1;

typedef struct{
	char naziv_tima[20];
	int ukupno_poena;
}tim_formula_1;

int UcitajVozace(char naziv[], vozac_formula_1 vozaci[])
{
	int n,i;
	FILE *f;
	f=fopen(naziv,"r");
	fscanf(f,"%d",&n);
	for(i=0;i<n;i++)
	{
		fscanf(f,"%s%s%d%s",vozaci[i].ime,vozaci[i].prezime,&vozaci[i].broj_na_bolidu,vozaci[i].naziv_tima);
		vozaci[i].broj_poena=0;
	}
	fclose(f);
	return n;
}

int UcitajTimove(char naziv[], tim_formula_1 timovi[])
{
	int n,i;
	FILE *f;
	f=fopen(naziv,"r");
	fscanf(f,"%d",&n);
	for(i=0;i<n;i++)
	{
		fscanf(f,"%s",timovi[i].naziv_tima);
		timovi[i].ukupno_poena=0;
	}
	fclose(f);
	return n;
}

void DodajUcinak(int broj_na_bolidu, int poeni, vozac_formula_1 vozaci[], int n)
{
	int i;
	for(i=0;i<n;i++)
	{
		if(vozaci[i].broj_na_bolidu==broj_na_bolidu)
			vozaci[i].broj_poena+=poeni;
	}
}

void UcitajTrke(char naziv[], vozac_formula_1 vozaci[], int n)
{
	int broj_na_bolidu,poeni;
	FILE *f;
	f=fopen(naziv,"r");
	while(!feof(f))
	{
		fscanf(f,"%d%d",&broj_na_bolidu,&poeni);
		DodajUcinak(broj_na_bolidu,poeni,vozaci,n);
	}
	fclose(f);
}

void IspisVozaca(FILE *f, vozac_formula_1 vozaci[], int n)
{
	int i;
	for(i=0;i<n;i++)
		fprintf(f,"%s %s - %d\n",vozaci[i].ime,vozaci[i].prezime,vozaci[i].broj_poena);
}

void PoeniTimova(FILE *f, vozac_formula_1 vozaci[], int n1, tim_formula_1 timovi[], int n2)
{
	int i,j;
	for(i=0;i<n1;i++)
	{
		for(j=0;j<n2;j++)
		{
			if(strcmp(vozaci[i].naziv_tima,timovi[j].naziv_tima)==0)
				timovi[j].ukupno_poena+=vozaci[i].broj_poena;
		}
	}
}

void IspisiTimove(FILE *f, tim_formula_1 timovi[], int n)
{
	int i;
	for(i=0;i<n;i++)
		fprintf(f,"%s - %d\n",timovi[i].naziv_tima,timovi[i].ukupno_poena);
}

void RangirajTimove(tim_formula_1 timovi[], int n)
{
	tim_formula_1 pom;
	int i,j;
	for(i=0;i<n-1;i++)
	{
		for(j=i+1;j<n;j++)
		{
			if(timovi[i].ukupno_poena<timovi[j].ukupno_poena)
			{
				pom=timovi[i];
				timovi[i]=timovi[j];
				timovi[j]=pom;
			}
		}
	}
}

void DodatniMotor(tim_formula_1 timovi[], int n)	//funkcija je tipa void jer se zna da ce nakon njenog izvrsenja ostati 3 tima, pa nema potrebe vracati n
{
	int i,j;
	i=n-3;
	while(i>0)
	{
		for(j=0;j<n-1;j++)
			timovi[j]=timovi[j+1];
		n--;
		i--;
	}
}

main()
{
	int n1,n2,i;
	FILE *f;
	vozac_formula_1 vozaci[30];
	tim_formula_1 timovi[20];
	char ulaz1[20],ulaz2[20],ulaz3[20],izlaz[20];
	scanf("%s%s%s%s",ulaz1,ulaz2,ulaz3,izlaz);
	n1=UcitajVozace(ulaz1,vozaci);
	n2=UcitajTimove(ulaz2,timovi);
	UcitajTrke(ulaz3,vozaci,n1);
	f=fopen(izlaz,"w");
	IspisVozaca(f,vozaci,n1);
	fprintf(f,"-----------------------\n");
	PoeniTimova(f,vozaci,n1,timovi,n2);
	IspisiTimove(f,timovi,n2);
	fprintf(f,"-----------------------\n");
	RangirajTimove(timovi,n2);
	IspisiTimove(f,timovi,n2);
	fprintf(f,"-----------------------\n");
	DodatniMotor(timovi,n2);
	IspisiTimove(f,timovi,3);
	fclose(f);
}
